#include <Wire.h>
#include <LiquidCrystal_I2C.h>
#include <Ds1302.h>

// === НАЛАШТУВАННЯ ЧАСУ ===
// Закоментуй рядок нижче (додай //), коли прошиваєш другий раз:
#define SET_TIME 

// Ініціалізація дисплея та годинника
LiquidCrystal_I2C lcd(0x27, 16, 2); 
Ds1302 rtc(8, 6, 7); // RST-8, CLK-6, DAT-7

// Набір сегментів для формування великих цифр
byte custom[8][8] = {
  {B00111,B01111,B11111,B11111,B11111,B11111,B11111,B11111}, // 0
  {B11111,B11111,B11111,B00000,B00000,B00000,B00000,B00000}, // 1
  {B11100,B11110,B11111,B11111,B11111,B11111,B11111,B11111}, // 2
  {B11111,B11111,B11111,B11111,B11111,B11111,B01111,B00111}, // 3
  {B00000,B00000,B00000,B00000,B00000,B11111,B11111,B11111}, // 4
  {B11111,B11111,B11111,B11111,B11111,B11111,B11110,B11100}, // 5
  {B11111,B11111,B11111,B00000,B00000,B00000,B11111,B11111}, // 6
  {B11111,B11111,B11111,B11111,B11111,B11111,B11111,B11111}  // 7
};

void setup() {
  lcd.init();
  lcd.backlight();
  lcd.clear();

  // Реєстрація символів у пам'ять LCD
  for (int i = 0; i < 8; i++) {
    lcd.createChar(i, custom[i]);
  }

  rtc.init();

  // Блок встановлення часу. Працює тільки якщо розкоментовано #define SET_TIME
  #ifdef SET_TIME
    String t = __TIME__; 
    Ds1302::DateTime dt;
    dt.hour = t.substring(0, 2).toInt();
    dt.minute = t.substring(3, 5).toInt();
    dt.second = t.substring(6, 8).toInt();
    rtc.setDateTime(&dt); 
  #endif
}

void loop() {
  Ds1302::DateTime now;
  rtc.getDateTime(&now);

  // Малюємо години (десятки та одиниці)
  drawDigit(now.hour / 10, 0);
  drawDigit(now.hour % 10, 4);

  // Малюємо хвилини (десятки та одиниці)
  drawDigit(now.minute / 10, 9);
  drawDigit(now.minute % 10, 13);

  // Мигаюча двокрапка (розділювач)
  lcd.setCursor(8, 0);
  lcd.print(now.second % 2 == 0 ? "." : " ");
  lcd.setCursor(8, 1);
  lcd.print(now.second % 2 == 0 ? "." : " ");

  delay(1000);
}

// Функція для малювання великої цифри з сегментів
void drawDigit(int n, int x) {
  // Карта побудови кожної цифри (3 сегменти зверху, 3 знизу)
  const byte table[10][6] = {
    {0, 1, 2, 3, 4, 5}, // 0
    {1, 2, 32, 4, 7, 4},// 1
    {6, 6, 2, 3, 4, 4}, // 2
    {6, 6, 2, 4, 4, 5}, // 3
    {3, 4, 7, 32, 32, 7},// 4
    {0, 6, 6, 4, 4, 5}, // 5
    {0, 6, 6, 3, 4, 5}, // 6
    {1, 1, 2, 32, 32, 7},// 7
    {0, 6, 2, 3, 4, 5}, // 8
    {0, 6, 2, 32, 32, 5} // 9
  };

  // Верхній рядок цифри
  lcd.setCursor(x, 0);
  for (int i = 0; i < 3; i++) {
    if (table[n][i] == 32) lcd.print(" "); 
    else lcd.write(table[n][i]);
  }

  // Нижній рядок цифри
  lcd.setCursor(x, 1);
  for (int i = 3; i < 6; i++) {
    if (table[n][i] == 32) lcd.print(" "); 
    else lcd.write(table[n][i]);
  }
}